IF OBJECT_ID('P_EXP_CTB_MOV_VENDAS_CONTABIL_CUSTO') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_EXP_CTB_MOV_VENDAS_CONTABIL_CUSTO
	END
 
GO
 
CREATE PROCEDURE P_EXP_CTB_MOV_VENDAS_CONTABIL_CUSTO  (@CD_EMP		INT,
													   @CD_FILIAL	INT,
													   @DT_INI		DATETIME,
													   @DT_FIM		DATETIME,
													   @FLAG_LIMPAR INT = 0)		
	

WITH ENCRYPTION AS  
SET NOCOUNT ON;
BEGIN TRY
BEGIN
	
	DECLARE @RS_CD_EMP				INT
	DECLARE @RS_CD_FILIAL			INT 	
	DECLARE @RS_DT_MOV				DATETIME
	DECLARE @RS_CD_SC				INT
	DECLARE @RS_DS_SC				VARCHAR(100)
	DECLARE @RS_CD_CTB_CNT_RED		VARCHAR(50)
	DECLARE @RS_CD_CTB_CNT			VARCHAR(50)
	DECLARE @RS_VLR_CUSTO			MONEY
   
	DECLARE @HIST					VARCHAR(250)
	DECLARE @NR_CONTROLE			VARCHAR (12)
	------------------------------------------------------------------------------------------------------------------------------
	--CRIANDO A TABELA TEMPORARIA ##CTB_EXP_MOV
	------------------------------------------------------------------------------------------------------------------------------
	EXEC P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV @FLAG_LIMPAR		
	 	 	 
	DECLARE RS_RESULT
	CURSOR FOR 								
		SELECT 
			T.CD_EMP				, 
			T.CD_FILIAL				, 
			T.DT_VD					,
		    T.CD_SC					,
		    T.DS_SC					,
		    T.CD_CTB_CNT_RED		,
		    T.CD_CTB_CNT			,
		    T.VLR_CUSTO 
		FROM UFD_EXP_CTB_MOV_VENDA_SECAO_CUSTO(@CD_EMP,@CD_FILIAL, @DT_INI, @DT_FIM) T	
		ORDER BY
			T.CD_EMP,
			T.CD_FILIAL,		
			T.DT_VD

		--Abrindo cursor
		OPEN RS_RESULT
		
		--Atribuindo valores do select nas variveis
		FETCH NEXT FROM RS_RESULT INTO 
				@RS_CD_EMP, 
				@RS_CD_FILIAL,						
				@RS_DT_MOV,
				@RS_CD_SC,
				@RS_DS_SC,
				@RS_CD_CTB_CNT_RED,
				@RS_CD_CTB_CNT,
				@RS_VLR_CUSTO				
								

		--Iniciando lao
		WHILE @@FETCH_STATUS = 0
			BEGIN	
				------------------------------------------------------------------------------------------------------------------
				--VENDAS CUSTO - Ctb_Cnt_Movimento_Estoque 
				------------------------------------------------------------------------------------------------------------------					
				SET @HIST = 'VALOR REF. CUSTO DAS  VENDAS N/ DATA CONF. CUPONS FISCAIS'
				SET @HIST = REPLACE (@HIST,'	',' ')
				--===== Tipos de Registros de movimento de vendas para codigo de Controle usado no  Nmero de Documento ===================
				
				--1 - vendas dinheiro, recargas no fiscal, cartao, convnio						  
				--2 - vendas icms
				--3 - vendas confins 
				--4 - vendas pis 
				--5 - vendas custo
				
								
				SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
								RIGHT('00'+ CAST( DAY( @RS_DT_MOV) AS VARCHAR),2) + 
								 RIGHT('00'+  CAST( MONTH(@RS_DT_MOV) AS VARCHAR),2) + 
								  RIGHT('00'+ CAST( YEAR(@RS_DT_MOV)AS VARCHAR),2) + '025'  -- 02 CD_MOVIMENTO 01 tipo de registro 
								  
			    --===========================================================================================================================
				
				INSERT INTO ##CTB_EXP_MOV
				
					   (CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
					   CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
					   VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
					   ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

				  
						SELECT									   
									@RS_CD_EMP					,								--CD_EMP
									@CD_FILIAL					,								--CD_FILIAL_EXPORT
									@RS_CD_FILIAL				,								--CD_FILIAL
									2 AS CD_MOVIMENTO			,								--CODIGO DO MOVIMENTO
									'MOVIMENTO DE VENDAS'		,								--MOVIMENTO			
									'VENDAS CUSTO - CREDITO'	,								--OPERACAO
									''							,								--OPERACAO_DEBITO                					
									0							,								--CD_CNT_RED_CREDITO
									''							,								--CD_CNT_CREDITO
									0							,								--CD_CNT_RED_DEBITO
									''							,								--CD_CNT_DEBITO								
									@RS_DT_MOV					,								--DT_MOV
									@HIST						,								--HIST
									ROUND(@RS_VLR_CUSTO,2)		,								--VLR_LANC
									'C'							,								--TP_TRANSA
									0 			,												--RATEIO_CENTRO_CUSTO
									'' 			,												--DS_CENTRO_CUSTO
									0 			,												--CNT_CENTRO_CUSTO
									0 			,												--VLR_CENTRO_CUSTO											
									'FILIAIS'  ,												--ORIG_CONTA
								    32			,												--COD_CONTA
								    OBJECT_NAME(@@PROCID)										--NM_PROCEDURE
								    , 'N' AS TIPO_LANCTO
								    , 0 AS CD_EVENTO
								    , 0  AS NR_DP
								    , 0  AS ANO
								    , @NR_CONTROLE AS NR_DOC
									, 0  AS CD_BC_LANC;

				------------------------------------------------------------------------------------------------------------------
				--VENDAS CUSTO - Ctb_Cnt_Movimento_Vendas_Custo 
				------------------------------------------------------------------------------------------------------------------					
				--SET @HIST = 'VALOR REF. ICMS/VENDAS N/ DATA CONF. CUPONS FISCAIS' caso 41532
				SET @HIST = 'VALOR REF. CUSTO DAS  VENDAS N/ DATA CONF. CUPONS FISCAIS'
				SET @HIST = REPLACE (@HIST,'	',' ')
				INSERT INTO ##CTB_EXP_MOV 
								
						  (CD_EMP, CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
						  CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
						  VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
						  ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)
						  				 
						SELECT									   
									@RS_CD_EMP					,								--CD_EMP
									@CD_FILIAL					,								--CD_FILIAL_EXPORT									
									@RS_CD_FILIAL				,								--CD_FILIAL
									2 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
									'MOVIMENTO DE VENDAS'		,								--MOVIMENTO			
									''							,								--OPERACAO
									'VENDAS CUSTO - DEBITO'		,								--OPERACAO_DEBITO                					
									0							,								--CD_CNT_RED_CREDITO
									''							,								--CD_CNT_CREDITO
									0							,								--CD_CNT_RED_DEBITO
									''							,								--CD_CNT_DEBITO								
									@RS_DT_MOV					,								--DT_MOV
									@HIST						,								--HIST
									ROUND(@RS_VLR_CUSTO,2)		,								--VLR_LANC
									'D'							,								--TP_TRANSA
									0 			,												--RATEIO_CENTRO_CUSTO
									'' 			,												--DS_CENTRO_CUSTO
									0 			,												--CNT_CENTRO_CUSTO
									0 			,												--VLR_CENTRO_CUSTO											
									'FILIAIS'  ,												--ORIG_CONTA
									31			,												--COD_CONTA
									OBJECT_NAME(@@PROCID)										--NM_PROCEDURE
									, 'N' AS TIPO_LANCTO
								    , 0 AS CD_EVENTO
								    , 0  AS NR_DP
								    , 0  AS ANO
								    , @NR_CONTROLE AS NR_DOC
									, 0  AS CD_BC_LANC;
																						
				--Atribuindo valores do select nas variveis
				FETCH NEXT FROM RS_RESULT INTO 
						@RS_CD_EMP, 
						@RS_CD_FILIAL,						
						@RS_DT_MOV,
						@RS_CD_SC,
						@RS_DS_SC,
						@RS_CD_CTB_CNT_RED,
						@RS_CD_CTB_CNT,
						@RS_VLR_CUSTO
								
			END

		CLOSE RS_RESULT
		DEALLOCATE RS_RESULT							
END

END TRY
BEGIN CATCH
	CLOSE RS_RESULT
	DEALLOCATE RS_RESULT	

	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			ERROR_SEVERITY() AS severidade,
			ERROR_STATE() AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			ERROR_MESSAGE() AS mensagem,
			GETDATE() AS dtErro;	
END CATCH					
  